%
% FPS/PSFi lab 04
% Author: AJF, 04 Oct 2025
%

% sampling frequency (FS) and frequency of square wave (Freq)
FS=48000; TS=1/FS; Freq=5E2;

% time vector
t=[0:TS:8E-3];
x = square(2*pi*Freq*t);
subplot(3,2,1)
plot(t,x)
xlabel('Time (s)'); ylabel('Amplitude'); title('Original wave')
axis([1.5E-3 7.5E-3 -1.2 1.2])

subplot(3,2,2)
plot(t,x)
xlabel('Time (s)'); title('Original wave')
axis([1.5E-3 7.5E-3 -1.2 1.2])

% filter order
order = 80;
% filter length
N=order+1;
n=[0:(N-1)];
% group delay, this will be discussed in a forthcoming lecture
atraso=(N-1)/2;

% this is a filter design method that we will discuss in a few weeks
% note the Matlab defnition: sinc(x) = sin(pi*x) / (pi*x)
hfilter = sinc(0.25*(n-atraso));
win=hamming(N).'; hfilter=hfilter.*win;
[H W]=freqz(hfilter, 1, 'whole');
subplot(3,2,3)
% plot the magnitude of the frequency response of filter 1
plot(W/pi, abs(H));
xlabel('\omega/\pi'); ylabel('Magnitude')
title('Frequency response 1')

% find the output of filter 1
y=conv(x, hfilter);
subplot(3,2,5)
plot(t, y(1:length(t)))
xlabel('Time (s)'); ylabel('Amplitude'); title('Filtered wave 1')
axis([1.5E-3 7.5E-3 -5.2 5.2])

% you don't need to understand this piece of code for now, you
% just need to understand that filter 2 is a transformation
% of filter 1, in what sense ? (hint: check its frequency response)
% all you need to know for now is that we have two filters whose
% impulse responses are known
hroots=roots(hfilter); gain=sum(hfilter);
for k=1:length(hroots)
    mult=abs(hroots(k));
   if( mult > 1 )
        hroots(k) = 1/conj(hroots(k));
   end
    
end
hfilter2=poly(hroots);
hfilter2 = gain*hfilter2/sum(hfilter2);

% plot the magnitude of the frequency response of filter 2 
[H W]=freqz(hfilter2, 1, 'whole');
subplot(3,2,4)
plot(W/pi, abs(H));
xlabel('\omega/\pi');
title('Frequency response 2')

% find the output of filter 2
y2=conv(x, hfilter2);
subplot(3,2,6)
plot(t, y2(1:length(t)))
xlabel('Time (s)'); ylabel('Amplitude'); title('Filtered wave 2')
axis([1.5E-3 7.5E-3 -5.2 5.2])

