// stm32f7_IIRorder2.c

#include "stm32f7_wm8994_init.h"
#include "stm32f7_display.h"

#define SOURCE_FILE_NAME "stm32f7_IIRorder2.c"
#define N 2
#define r 0.8f
#define r2 r*r
#define Gain (r*r - r + 1)

extern int16_t rx_sample_L;
extern int16_t rx_sample_R;
extern int16_t tx_sample_L;
extern int16_t tx_sample_R;

float32_t w[N+1] = {0.0, 0.0 ,0.0};

enum filtertype{AllPole, AllPass};

void BSP_AUDIO_SAI_Interrupt_CallBack()
{
// when we arrive at this interrupt service routine (callback)
// the most recent input sample values are (already) in global variables
// rx_sample_L and rx_sample_R
// this routine should write new output sample values in
// global variables tx_sample_L and tx_sample_R
  int16_t i;
  float32_t w0, yn; 
  
  // uncomment jut one of the following two lines
  enum filtertype myfilter=AllPole;
  //enum filtertype myfilter=AllPass;
	

  w0  = (float32_t)(rx_sample_L);
  
  switch (myfilter)
  {
	case AllPole:
	   w0 += ( (float32_t)(r) * w[N-1] - (float32_t)(r2) * w[N] );
	   yn = (float32_t)(Gain) * w0;
	   break;
  	case AllPass:
	   w0 += ( (float32_t)(r) * w[N-1] - (float32_t)(r2) * w[N] );
	   yn = (float32_t)(r2) * w0 - (float32_t)(r) * w[N-1] +  w[N];
	   break;
	default:
	   yn = w0;
  }
  
  tx_sample_L = rx_sample_L;
  tx_sample_R = (int16_t)(yn);


  w[0] = w0;
  for (i=N ; i>0 ; i--) w[i] = w[i-1];

  BSP_LED_Toggle(LED1);

  return;
}

int main(void)
{

  stm32f7_wm8994_init(AUDIO_FREQUENCY_8K,
                      IO_METHOD_INTR,
                      INPUT_DEVICE_INPUT_LINE_1,
                      OUTPUT_DEVICE_HEADPHONE,
                      WM8994_HP_OUT_ANALOG_GAIN_0DB,
                      WM8994_LINE_IN_GAIN_0DB,
                      WM8994_DMIC_GAIN_9DB,
                      SOURCE_FILE_NAME,
	              NOGRAPH);

  while(1){}
}
