// stm32f7_fir_intr_FPS81.c

#include "stm32f7_wm8994_init.h"
#include "FPS81.h"
#include "stm32f7_display.h"
#define SOURCE_FILE_NAME "stm32f7_fir_intr_FPS81.c"

extern int16_t rx_sample_L;
extern int16_t rx_sample_R;
extern int16_t tx_sample_L;
extern int16_t tx_sample_R;

#define Nm1 2*N-1

enum filtertype{Plain, Shifted, Upsampled};

float32_t x[Nm1];


void BSP_AUDIO_SAI_Interrupt_CallBack()
{
  int16_t i,j;
  float32_t yn = 0.0;


  // uncomment just one of the following three lines
   enum filtertype myfilter=Plain;
  // enum filtertype myfilter=Shifted;
  // enum filtertype myfilter=Upsampled;
	

  x[0]  = (float32_t)(rx_sample_L);
  BSP_LED_On(LED1);
  
  switch (myfilter)
  {
	case Plain:
	   for (i=0 ; i<N ; i++) yn += h[i] * x[i];
	   break;
  	case Shifted:
	   // please complete your code here
	   break;
	case Upsampled:
	   // please complete your code here
	   break;
	default:
	   for (i=0 ; i<N ; i++) yn += h[i] * x[i];
  }

  for (j=(Nm1-1) ; j>0 ; j--) x[j] = x[j-1];

  BSP_LED_Off(LED1);
  tx_sample_R = (int16_t)(yn);
  tx_sample_L = tx_sample_R;

  return;
}

int main(void)
{  
  stm32f7_wm8994_init(AUDIO_FREQUENCY_8K,
                      IO_METHOD_INTR,
                      INPUT_DEVICE_INPUT_LINE_1,
                      OUTPUT_DEVICE_HEADPHONE,
                      WM8994_HP_OUT_ANALOG_GAIN_0DB,
                      WM8994_LINE_IN_GAIN_0DB,
                      WM8994_DMIC_GAIN_9DB,
                      SOURCE_FILE_NAME,
                      NOGRAPH);
  
  while(1){}
}
