// stm32f7_fir_intr_diff_HT.c

#include "stm32f7_wm8994_init.h"
#include "FPS_diff.h"
#include "FPS_HT.h"
#include "stm32f7_display.h"
#define SOURCE_FILE_NAME "stm32f7_fir_intr_FPS_diff_HT.c"

extern int16_t rx_sample_L;
extern int16_t rx_sample_R;
extern int16_t tx_sample_L;
extern int16_t tx_sample_R;

#define DELAY (N-1)/2

enum filtertype{diff, HT};

float32_t x[N];


void BSP_AUDIO_SAI_Interrupt_CallBack()
{
  int16_t i,j;
  float32_t *hptr, xref, yn = 0.0;


  // uncomment just one of the following two lines
  // enum filtertype myfilter=diff;
     enum filtertype myfilter=HT;
	

  x[0]  = (float32_t)(rx_sample_L);
  BSP_LED_On(LED1);
  
  switch (myfilter)
  {
	case diff:
	   hptr=hdiff;
	   break;
  	case HT:
	   hptr=hHT;
	   break;
	default:
	   hptr=hHT;
  }

	for (i=0 ; i<N ; i++) yn += *(hptr++) * x[i];
	
	xref = please complete here ;
	
  for (j=(N-1) ; j>0 ; j--) x[j] = x[j-1];

  BSP_LED_Off(LED1);
  tx_sample_R = (int16_t)(yn);    // will appear in OUT LEFT channel
  tx_sample_L = (int16_t)(xref);  // will appear in OUT RIGHT channel

  return;
}

int main(void)
{  
  stm32f7_wm8994_init(AUDIO_FREQUENCY_8K,
                      IO_METHOD_INTR,
                      INPUT_DEVICE_INPUT_LINE_1,
                      OUTPUT_DEVICE_HEADPHONE,
                      WM8994_HP_OUT_ANALOG_GAIN_0DB,
                      WM8994_LINE_IN_GAIN_0DB,
                      WM8994_DMIC_GAIN_9DB,
                      SOURCE_FILE_NAME,
                      NOGRAPH);
  
  while(1){}
}
