// stm32f7_FIRadapt_intr_FPS.c
// uses normalized LMS

#include "stm32f7_wm8994_init.h"
#include "stm32f7_display.h"

#define BLOCK_SIZE 1
#define NUM_TAPS 64 // was 256

#define SOURCE_FILE_NAME "stm32f7_FIRadapt_intr_FPS.c"

// this is adapted from stm32f7_dft.c
typedef struct
{
  float32_t real; // this represents the ideal iumpulse response
  float32_t imag; // this represents the adaptive filter impulse response
} COMPLEX;

// reference impulse response versus estimated impulse response
COMPLEX refVSest[NUM_TAPS];


float32_t beta = 1E-3; // between 1E-4 and 1E-0 // using normalized LMS !

float32_t hREF[NUM_TAPS] = {0.0f};
float32_t x[NUM_TAPS] = {0.0f};
float32_t h[NUM_TAPS] = {0.0f};

extern int16_t rx_sample_L;
extern int16_t rx_sample_R;
extern int16_t tx_sample_L;
extern int16_t tx_sample_R;

// float32_t cmplx_buf[2*PING_PONG_BUFFER_SIZE];
// float32_t *cmplx_buf_ptr;
// float32_t outbuffer[PING_PONG_BUFFER_SIZE];
volatile int intr_flag = 0;


void BSP_AUDIO_SAI_Interrupt_CallBack()
{
  float32_t input;
  int16_t i, k;
	static int16_t index = -1;
	
  float32_t yn, adapt_out, error, dummy, energy;

  BSP_LED_On(LED1);
  
	index++;  index = index%32768;
  // input = (float32_t)(prbs(8000));
  // input = (float32_t)(rx_sample_L);
  input = 0.5f * prand();
	// input = 4000.0f*sin(2*PI*3000.0f/8000.0f*(float32_t)(index));
  x[0] = input; yn=0.0;
  for (k=0 ; k<NUM_TAPS ; k++)
  {
    yn += x[k] * hREF[NUM_TAPS-1-k];
  }

  adapt_out = 0.0; energy = 0.0;
  for (i=0; i<NUM_TAPS; i++)
  {
    adapt_out += (h[i]*x[i]);
    energy += x[i]*x[i];
  }
  error = yn - adapt_out;
  for (i = NUM_TAPS-1; i >= 0; i--) // update weights
  {
    dummy = beta*error;
    dummy = dummy*x[i];
    h[i] = h[i] + dummy/energy;
  }
	for (i = NUM_TAPS-1; i > 0; i--) x[i] = x[i-1]; // update delay line
  
  for(k=0; k < NUM_TAPS; k++)
  {
     refVSest[k].imag = h[NUM_TAPS-1-k]; // update most recent estimate
  }
  
  BSP_LED_Off(LED1);
  tx_sample_R = (int16_t)(error);
  tx_sample_L = (int16_t)(input);
  return;
}


int main(void)
{  
  int start, k;
  int button = 0;
 
  // initialize our reference FIR impulse response
  start = 4; 
  for(k=0; k <= 5; k++)
  {
    *(hREF+start+k)    = -0.1f * (float32_t)(k+1);
	  *(hREF+start+10-k) = *(hREF+start+k);
  }
  start += 11;
  for(k=0; k <= 16; k++)
  {
    *(hREF+start+k)    = 0.15f * (float32_t)(k+1);
	  *(hREF+start+32-k) = *(hREF+start+k);
  }
  start += 33;
  for(k=0; k < 11; k++)
  {
     *(hREF+start+k)    = *(hREF+4+k);
  }
  
  // this data is to be plotted (ideal versus estimated impulse response)
  for(k=0; k < NUM_TAPS; k++)
  {
     refVSest[k].real = *(hREF+k);
     refVSest[k].imag = 0.0f; // start with zeros
		 h[k]=0.0f; x[k]=0.0f;
  }
  
  
  stm32f7_wm8994_init(AUDIO_FREQUENCY_8K,
                      IO_METHOD_INTR,
                      INPUT_DEVICE_INPUT_LINE_1,
                      OUTPUT_DEVICE_HEADPHONE,
                      WM8994_HP_OUT_ANALOG_GAIN_6DB,
                      WM8994_LINE_IN_GAIN_0DB,
                      WM8994_DMIC_GAIN_0DB,
                      SOURCE_FILE_NAME,
	              GRAPH);
  while(1)
  {
    button = checkButtonFlag();
    if (button == 1) 
    {
			plotLMS(h, NUM_TAPS, LIVE);
    }
    else if (button == 0)
    {
      plotWave(&refVSest->real, NUM_TAPS, 1, 1);
      // for(i=0; i<NUM_TAPS; i++)
      // {
      //  cmplx_buf[2*i] = h[i];
      //  cmplx_buf[2*i + 1] = 0.0;
      // }
      // arm_cfft_f32(&arm_cfft_sR_f32_len256, (float32_t *)(cmplx_buf), 0, 1);
      // arm_cmplx_mag_f32((float32_t *)(cmplx_buf),(float32_t *)(outbuffer), NUM_TAPS);
      // plotLogFFT(outbuffer, NUM_TAPS, LIVE);
    }
  }
}


